/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.Config;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.ServerConfig;

public class CurrentSeason {
    public static boolean isTropicalSeason() {
        if (((Boolean)Config.showTropicalSeason.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            return SeasonHelper.usesTropicalSeasons((Holder)Objects.requireNonNull(mc.f_91073_).m_204166_(Objects.requireNonNull(mc.f_91074_).m_20097_()));
        }
        return false;
    }

    public static String getCurrentSeasonState() {
        Minecraft mc = Minecraft.m_91087_();
        if (CurrentSeason.isTropicalSeason()) {
            return SeasonHelper.getSeasonState((Level)((Level)Objects.requireNonNull(mc.f_91073_))).getTropicalSeason().toString();
        }
        if (((Boolean)Config.showSubSeason.get()).booleanValue()) {
            return SeasonHelper.getSeasonState((Level)((Level)Objects.requireNonNull(mc.f_91073_))).getSubSeason().toString();
        }
        return SeasonHelper.getSeasonState((Level)((Level)Objects.requireNonNull(mc.f_91073_))).getSeason().toString();
    }

    public static String getSeasonStateLower() {
        return CurrentSeason.getCurrentSeasonState().toLowerCase();
    }

    public static String getSeasonFileName() {
        Minecraft mc = Minecraft.m_91087_();
        if (CurrentSeason.isTropicalSeason() || !((Boolean)Config.showSubSeason.get()).booleanValue()) {
            if (CurrentSeason.isTropicalSeason()) {
                return CurrentSeason.getCurrentSeasonState().toLowerCase().substring(CurrentSeason.getCurrentSeasonState().toLowerCase().length() - 3);
            }
            return CurrentSeason.getCurrentSeasonState().toLowerCase();
        }
        return SeasonHelper.getSeasonState((Level)((Level)Objects.requireNonNull(mc.f_91073_))).getSeason().toString().toLowerCase();
    }

    public static int getDate() {
        Minecraft mc = Minecraft.m_91087_();
        ISeasonState seasonState = SeasonHelper.getSeasonState((Level)((Level)Objects.requireNonNull(mc.f_91073_)));
        int subSeasonDuration = (Integer)ServerConfig.subSeasonDuration.get();
        int seasonDay = seasonState.getDay();
        int seasonDate = seasonDay % (subSeasonDuration * 3) + 1;
        int subDate = seasonDay % subSeasonDuration + 1;
        int subTropDate = (seasonDay + 24) % 16 + 1;
        if (CurrentSeason.isTropicalSeason()) {
            return subTropDate;
        }
        if (((Boolean)Config.showSubSeason.get()).booleanValue()) {
            return subDate;
        }
        return seasonDate;
    }

    public static String getSeasonIcon(String seasonFileName) {
        for (SeasonList season : SeasonList.values()) {
            if (!Objects.equals(season.getFileName(), seasonFileName)) continue;
            return season.seasonIconChar;
        }
        return null;
    }

    public static ArrayList<Component> getSeasonName() {
        ArrayList<Component> text = new ArrayList<Component>();
        if (((Boolean)Config.showDay.get()).booleanValue()) {
            text.add((Component)Component.m_237110_((String)"desc.seasonhud.icon", (Object[])new Object[]{CurrentSeason.getSeasonIcon(CurrentSeason.getSeasonFileName())}).m_130948_(Common.SEASON_STYLE));
            text.add((Component)Component.m_237110_((String)"desc.seasonhud.detailed", (Object[])new Object[]{Component.m_237115_((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower())), CurrentSeason.getDate()}));
        } else {
            text.add((Component)Component.m_237110_((String)"desc.seasonhud.icon", (Object[])new Object[]{CurrentSeason.getSeasonIcon(CurrentSeason.getSeasonFileName())}).m_130948_(Common.SEASON_STYLE));
            text.add((Component)Component.m_237110_((String)"desc.seasonhud.summary", (Object[])new Object[]{Component.m_237115_((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower()))}));
        }
        return text;
    }

    public static enum SeasonList {
        SPRING(0, "spring", "\uea00"),
        SUMMER(1, "summer", "\uea01"),
        AUTUMN(2, "autumn", "\uea02"),
        FALL(3, "fall", "\uea03"),
        WINTER(4, "winter", "\uea04"),
        DRY(5, "dry", "\uea05"),
        WET(6, "wet", "\uea06");

        private final int idNum;
        private final String seasonFileName;
        private final String seasonIconChar;

        private SeasonList(int id, String fileName, String iconChar) {
            this.idNum = id;
            this.seasonFileName = fileName;
            this.seasonIconChar = iconChar;
        }

        public int getId() {
            return this.idNum;
        }

        public String getFileName() {
            return this.seasonFileName;
        }

        public String getIconChar() {
            return this.seasonIconChar;
        }
    }
}

